# AB Circle Smart Card I/O Android Library

The library "AbcTerminalFactory" is a java module for Android applications to communicate with ABC USB CCID Smart Card Readers through the Java Smart
Card I/O API defined by [JSR 268](https://jcp.org/en/jsr/detail?id=268); to do so the module implements a custom "terminal factory service provider interface"
(TerminalFactorySpi).

The Java Smart Card I/O API defines a Java API for communication with Smart
Cards using ISO/IEC 7816-4 APDUs. It thereby allows Java applications to
interact with applications running on the Smart Card, to store and retrieve data
on the card, etc.

## Supported Readers

- CIR115
- CIR125
- CIR135
- CIR215
- CIR315
- CIR415
- CIR515
- CIR615

## Getting Started

1. Evaluate Usb Demo application by installing android app, see "Evaluate Demo Project - Option 1"
2. Evaluate Usb Demo application source in Android Studio, see "Evaluate Demo Project - Option 2"
3. Install libraries to your user application, see "Installation"

### Development Environment

``` text
Android Studio - Android Studio Chipmunk | 2021.2.1 Patch 1+
```

By default, Android Studio does not supply the Java Smart Card I/O classes.
Therefore in order to use the api, the javax.smartcardio package needs to
be manually imported. To make life easy for you we have packaged a copy of
javax.smartcardio package to a module (smartcardio) for you to use.

The library **smartcardio** imports Java packages from OpenJDK8:

``` java
- javax.smartcardio
- sun.net.www
- sun.nio.cs
- sun.security.action
- sun.security.jca
- sun.security.util
```

## Evaluate Demo Project

Option 1 Build demo project from source:

- To evaluate demo project, select Open from File menu on Android Studio. Choose
   "UsbDemo".

Option 2 Install APK:

- You can also run the demo project without Android Studio installed. Copy
   "UsbDemo-x.y.z.apk" to your Android device. Launch the installation by
   clicking the file icon on any File Explorer application.

## Installation

### Deploy *AB Circle Smart Card I/O Android Library* in User Application

1. To use the class library in your project, create a libs folder in project directory.

2. Copy "smartcardio-x.y.z.jar" and "abcTerminalFactory-.x.y.z.jar" into the libs folder.

3. Click File, Project Structure -> Dependencies.

4. Under "Declared Dependencies", press "+" / "Add Dependency" -> "2 JAR/AAR Dependency"

5. Type "libs" into Step 1 box and press OK

6. Add line below to application AndroidManifest.xml

``` xml
<uses-feature android:name="android.hardware.usb.host" />
```

e.g.

``` xml
    ...
    ...
    <uses-feature android:name="android.hardware.usb.host" />

    <application
    ...
    ...
    ...
```

## Notes for Xamarin Library binding; Transforms to add to Metadata.xml

``` xml
<remove-node path="/api/package[@name='sun.security.action']/class[@name='GetPropertyAction']" />

<remove-node path="/api/package[@name='com.abc.terminalfactory']/class[@name='UsbTerminalFactorySpi']" />
<remove-node path="/api/package[@name='com.abc.terminalfactory']/class[@name='UsbTerminalProvider']" />
```

## Built With

- [Android Studio](https://developer.android.com/studio) - Android Studio Jellyfish | 2023.3.1 Patch 2

## History

### Usb Demo

V1.5.0

- Update abcTerminalFactory to V1.5.0
 
V1.4.9

- Update abcTerminalFactory to V1.4.9
 
V1.4.8

- Update abcTerminalFactory to V1.4.8

V1.4.7

- Update abcTerminalFactory to V1.4.7

V1.4.6

- Update abcTerminalFactory to V1.4.6
- Upgrade Gradle to 8.8

V1.4.5

- Update abcTerminalFactory to V1.4.5
- Upgrade Gradle to 8.0

V1.4.4

- Update abcTerminalFactory to V1.4.4
- Upgrade Gradle to 7.4.2

V1.4.3

- Update abcTerminalFactory to V1.4.3
- Upgrade Gradle to 7.2.1
- Change SDK to 33

V1.4.2

- Update abcTerminalFactory to V1.4.2

V1.4.1

- Update abcTerminalFactory to V1.4.1

V1.4.0

- Update abcTerminalFactory to V1.4.0
- Upgrade Gradle to 7.0.1
- Increase target version to Android 12

V1.3.0

- Update abcTerminalFactory to V1.3.0
Add Button to:

- get reader firmware
- toggle card monitoring

V1.2.9

- Update abcTerminalFactory to V1.2.9

V1.2.8

- Update abcTerminalFactory to V1.2.8

V1.2.7

- Update abcTerminalFactory to V1.2.7

V1.2.6

- Update abcTerminalFactory to V1.2.6
- Fix UpdateTerminalSelectorOnChangeTask not resuming after onStop() event

V1.2.5

- Update abcTerminalFactory to V1.2.5

V1.2.4

- Update abcTerminalFactory to V1.2.4
- Add Async task to auto refresh terminal list

V1.2.3

- Update abcTerminalFactory to V1.2.3

V1.2.2

- Update abcTerminalFactory to V1.2.2

V1.2.1

- Update abcTerminalFactory to V1.2.1

V1.2.0

- Update abcTerminalFactory to V1.2.0

V1.1.1

- Add API Documentation

V1.1.0

- Change API to fix support for 4.4.4 - 6.0
- UsbSmartCard.getInstance(this).getFactory() does not work below Android 7
- Fix use UsbSmartCard.terminals().list() to get terminals instead of UsbSmartCard.getInstance(this).getFactory().terminals.list()

V1.0.0

- Initial release

### abcTerminalFactory

V1.5.0

- Add support for custom reader

V1.4.9

- Add CIR115 CT support
 
V1.4.8

- Add CIR315-SE support

V1.4.7

- Fix issue with terminal refresh on Android 14

V1.4.6

- Add Android 14 Support

V1.4.5

- Add CIR135 support

V1.4.4

- Retry PPS with Default speed (0x11) on card connect error
- Fix USB permission event handling for Android 13
- Optimise proguard/obfuscation rules to avoid class name clashes when used with ABC BLE library

V1.4.3

- Improve T=15 Handling
- Fix Extended APDU chaining for APDU readers (bug does not apply to CIR115 and CIR125)
  where T=1 (APDU length > max ccid length) && (smaller than (max ccid length * 2))
- Update SDK target to android-33 (Android 13)

V1.4.2

- Optmise proguard/obfuscation rules to simplify xamarin java bindings

V1.4.1

- Add CIR115-compatible Support
- Update SDK target to android-31 (Android 12)

V1.4.0

- Add CIR125 Support

- Bug fix for Contact Readers
  Send(PPS) when FiDi=0x11 and Card Protocol is T=1

V1.3.0

- Add CIR515 Support
- Add CIR615 Support
- Add API for getting FW Version

- Fix card detection behavior so that the following program flow works:
1.cardTerminals.waitForChange();
2.cardTerminals.list(CardTerminals.State.CARD_INSERTION);
3.cardTerminals.list(CardTerminals.State.CARD_REMOVAL);

V1.2.9

- Fix ATR parsing, default to T=0 if no TD is present

V1.2.8

- card.Disconnect(true) powers down card instead of resetting card.

V1.2.7

- Fix ATR decoding TC1 incorrectly checksum type
- Add Extra Guard Time delay for TPDU readers T0 = 12etu, T1 = 22etu
- Release USB devices when activity is stopped
- Don't send setParameter in specific mode - TA2(bit7)

V1.2.6

- Change UsbSmartCard onCreate() API to onResume():
- onResume() re-registers android usb intent receivers and re-enumerates disconnected devices.
- Fix USB CCID zero-packet handling
- TPDU T=1 ABORT throws CCID_ICC_ABORT

V1.2.5

- Add UsbSmartCard API
- onCreate() - re-registers android usb intent receivers
- onStop() - un-registers android usb intent receivers

V1.2.4

- Fix reader numbering uniqueness when multiple readers are attached at the same time.

V1.2.3

- TPDU readers: Don't negotiate IFS if IFSC is the default value (32)

V1.2.2

- Fix <cardTerminals>.list(CardTerminals.State.CARD_INSERTION) and <cardTerminals>.list(CardTerminals.State.CARD_Removal);
- Disable debug logs

V1.2.1

- Fix ATR IFSC decoding for T=1 cards (was defaulting to 32)

V1.2.0

- Add CIR115 Support

V1.1.0

- Change API to fix support for 4.4.4 - 6.0
- UsbSmartCard.getInstance(this).getFactory() does not work below Android 7
- Fix use UsbSmartCard.terminals().list() to get terminals instead of UsbSmartCard.getInstance(this).getFactory().terminals.list()

V1.0.0

- Initial release
- Support CIR215, CIR315 and CIR415

### smartcardio

v1.1.0

- Remove unnecessary files

v1.0.0

- Initial release
- Import javax.smartcardio and package dependencies.

## Versioning

We use [SemVer](http://semver.org/) for versioning.

## Authors

- **ABC Software Team**

See also the list of [contributors]() who participated in this project.

## License

``` text
Copyright (c) 2018-2025, AB Circle Ltd. All rights reserved.
```

``` text
OpenJDK
Copyright (c) 1998-2016, Oracle and/or its affiliates. All rights reserved.

This code is free software; you can redistribute it and/or modify itfff
under the terms of the GNU General Public License version 2 only, as
published by the Free Software Foundation.  Oracle designates this
particular file as subject to the "Classpath" exception as provided
by Oracle in the LICENSE file that accompanied this code.

This code is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
version 2 for more details (a copy is included in the LICENSE file that
accompanied this code).

You should have received a copy of the GNU General Public License version
2 along with this work; if not, write to the Free Software Foundation,
Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
```

``` text
OpenJDK (the "Name") is a trademark of Oracle America, Inc. ("Oracle")
(the "Trademark Owner").
```

``` text
Android is a trademark of Google LLC.
```
